class SignUpModel{
  final String firstName;
  final String lastName;
  final String email;
  final String password;
  final bool? agree;
  final String type;
  String? companyName;
  String? ownerName;

  SignUpModel({
      required this.firstName,
    required this.lastName,
    required this.email,
    required this.password,
    required this.agree,
    required this.type,
    this.companyName,
    this.ownerName,
  });
    Map<String, dynamic> toMap() {
    return {
      'firstname': firstName,
      'lastname': lastName,
      'email': email,
      'password': password,
      'password_confirmation':password,
      'agree': agree.toString()=='true'?'true':'',
    };
  }

  factory SignUpModel.fromMap(Map<String, dynamic> map) {
    return SignUpModel(
      firstName: map['firstname'] as String,
      lastName: map['lastname'] as String,
      email: map['email'] as String,
      password: map['password'] as String,
      companyName: map['company_name'] as String,
      ownerName: map['owner_name'] as String,
       type: map['type'] as String,
      agree: map['agree'] as bool,
    );
  }
}